/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.bpcrcon;

import com.ibm.hwmca.base.bpcrcon.BackupCriticalConsoleDataResourceBundle;
import com.ibm.hwmca.base.bpcrcon.BackupErrorIds;
import com.ibm.hwmca.base.bpcrcon.BackupException;
import com.ibm.hwmca.base.bpcrcon.BackupImpl;
import com.ibm.hwmca.base.bpcrcon.BackupParameterKeys;
import com.ibm.hwmca.base.bpcrcon.BackupParameters;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class BackupCriticalConsoleData
implements BackupErrorIds,
BackupParameterKeys {
    private static final String TRACE_MASKT = "XBKPUTPT";
    private static final String TRACE_MASKF = "XBKPUTPF";
    private static final String TRACE_MASKD = "XBKPUTPD";
    private UserContext usercontext = null;
    private LocalizableText taskname;
    BackupImpl backupImpl = new BackupImpl();
    BackupParameters backupParameters = null;

    public BackupCriticalConsoleData() {
        Trace.trace(TRACE_MASKT, "-> BackupCriticalConosoleData ctor");
        this.backupParameters = BackupParameters.getBackupParameters();
        Trace.trace(TRACE_MASKT, "<- BackupCriticalConsoleData ctor");
    }

    public void performBackup() throws BackupException {
        Trace.trace(TRACE_MASKT, "-> BackupCriticalConsoleData.performBackup()");
        try {
            byte[] cpxStatus = SimServer.getSimServer().readSim(5);
            if (cpxStatus[0] != 4 && cpxStatus[0] != 2) {
                throw new BackupException("Invalid method.  BackupCriticalConsoleData.performBackup() is valid for zSeries and PSeries HMCs Only ");
            }
            this.backupImpl.backupPreparation();
            Trace.trace(TRACE_MASKF, "completed backup preparation");
            this.backupImpl.doBackup();
            Trace.trace(TRACE_MASKT, "<- BackupCriticalConsoleData.performBackup()");
        }
        catch (BackupException bexc) {
            Trace.trace(TRACE_MASKF, "caught exception: " + bexc.getMessage());
            Trace.trace(TRACE_MASKF, "caught " + BackupCriticalConsoleDataResourceBundle.BackupErrors(this.backupImpl.getState()) + " : " + bexc.getMessage());
            new FrameworkLog(BackupErrorIds._logInfo, 261, bexc).log();
            throw bexc;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during init: " + e);
            new FrameworkLog(BackupErrorIds._logInfo, 261, e).log();
            throw new BackupException(e);
        }
    }

    public void performBackup(String netId, String nau, String crl, boolean dvdMounted, int backup_timeout) throws BackupException {
        Trace.trace(TRACE_MASKT, "-> BackupCriticalConsoleData.performBackup()");
        try {
            byte[] cpxStatus = SimServer.getSimServer().readSim(5);
            if (cpxStatus[0] != 1 && cpxStatus[0] != 3) {
                throw new BackupException("Invalid method. BackupCriticalConsoleData.performBackup(String netId,String,String,boolean,int) is valid for zSeries and PSeries HMCs Only ");
            }
            this.backupImpl.doBackup();
            Trace.trace(TRACE_MASKT, "<- BackupCriticalConsoleData.performBackup()");
        }
        catch (BackupException bexc) {
            Trace.trace(TRACE_MASKF, "caught exception: " + bexc.getMessage());
            Trace.trace(TRACE_MASKF, "caught " + BackupCriticalConsoleDataResourceBundle.BackupErrors(this.backupImpl.getState()) + " : " + bexc.getMessage());
            new FrameworkLog(BackupErrorIds._logInfo, 261, bexc).log();
            throw bexc;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during init: " + e);
            new FrameworkLog(BackupErrorIds._logInfo, 261, e).log();
            throw new BackupException(e);
        }
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> BackupCriticalConsoleData.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        HException hexc = new HException(throwable);
        new FrameworkLog(BackupErrorIds._logInfo, 261, hexc).log();
        Trace.trace(TRACE_MASKT, "<- BackupCriticalConsoleData.logException()");
    }

    public PersistentData getPersistentData() {
        return null;
    }

    public int getState() {
        return this.backupImpl.getState();
    }

    public String backupErrorsLong(int index) throws IllegalArgumentException {
        return BackupCriticalConsoleDataResourceBundle.BackupErrorsLong(index);
    }
}

